@echo off
:: =========================
:: Auto backup labdb
:: =========================

:: Variables
set BACKUP_PATH=D:\DBBC
set MYSQL_PATH=C:\wamp64\bin\mysql\mysql8.2.0\bin
set USER=root
set PASSWORD=
set DBNAME=labdb

:: Create backup folder if it doesn't exist
if not exist "%BACKUP_PATH%" mkdir "%BACKUP_PATH%"

:: Get current date and time for filename (format: YYYY-MM-DD_HH-MM-SS)
for /f "tokens=2-4 delims=/ " %%i in ('date /t') do set dt=%%k-%%j-%%i
for /f "tokens=1-2 delims=: " %%i in ('time /t') do (
    set tm=%%i-%%j
)
set FILENAME=%DBNAME%_backup_%dt%_%tm%.sql

:: Backup database
"%MYSQL_PATH%\mysqldump.exe" -u %USER% -p%PASSWORD% %DBNAME% > "%BACKUP_PATH%\%FILENAME%"

:: Check if backup was successful
if %ERRORLEVEL% EQU 0 (
    echo Backup completed successfully: %FILENAME%
) else (
    echo Backup failed!
)

:: Delete backups older than 7 days
forfiles /p "%BACKUP_PATH%" /s /m *.sql /d -7 /c "cmd /c del @path"

echo Backup script finished.
pause
